clearvars
close all

Lvalues = [20,50,80];
Lmarkers = {'ko','kd','k^'};
fcolour = {'r','b','g'};
type1 = [1,0,1]; %Plot lambda = 0,5,10,15...
type2 = [1,1,0]; %Plot lambda = 2.5,7.5,12.5...
formatSpec = '%f';

load('K.mat');
hold on, plot(K(:,2),K(:,1),'k-','LineWidth',3.2,'DisplayName','Theory');

hold on, plot([20,20],[0,0.6],'k--','LineWidth',3.2);
hold on, plot([35,39.4],[0.48,0.48],'k--','LineWidth',3.2);
text(41,0.484,'Phase','FontSize',16);
text(38,0.43,'Transition','FontSize',16);

for j=1:size(Lvalues,2)
    L=Lvalues(j);
    lfile=sprintf('KAlg%d.mat',L);
    load(lfile);
    Kave=mean(A(:,2:end),2);
    Llabel = sprintf('L=%d',L);
    svals=[];
    Kvals=[];
    for i=1:size(A,1)
        if(type1(j)==1)
            if mod(A(i,1),5)==0
                svals=[svals,A(i,1)];
                Kvals=[Kvals,Kave(i)];
            end
        end
        if(type2(j)==1)
            if mod(A(i,1)+2.5,5)==0
                svals=[svals,A(i,1)];
                Kvals=[Kvals,Kave(i)];
            end
        end
    end
    figure(1), hold on, plot(svals,Kvals/L,Lmarkers{j},'MarkerFaceColor',fcolour{j},'MarkerSize',10,'DisplayName',Llabel);
    figure(1), hold on, plot(4,0.3-0.08*j,Lmarkers{j},'MarkerFaceColor',fcolour{j},'MarkerSize',10,'DisplayName',Llabel);
    lLabel = sprintf('$L=%d$',L);
    text(7,0.3-0.08*j,lLabel,'FontSize',20,'interpreter','latex');
end

figure(1), hold on, plot([2, 6],[0.3,0.3],'k-','LineWidth',3.2);
text(7,0.3,'Theory','FontSize',20,'interpreter','latex');

xlim([0,50]);
xlabel('$\lambda$','interpreter','latex');
ylabel('$\mathcal{K}(\lambda)$','interpreter','latex');
set(gca, 'FontSize', 20);

set(gca, 'FontSize',24);
set(gca,'linewidth',2);
    
saveas(gcf,'KoverL.png');


figure(2);
load('phi.mat');
load('sL2.mat');

hold on, plot(sL2(:,1),phi(:,1),'k-','LineWidth',3.2,'DisplayName','Theory');

for j=1:size(Lvalues,2)
    L=Lvalues(j);
    lfile=sprintf('PsiAlg%d.mat',L);
    load(lfile);
    psiave=mean(A(:,2:end),2);
    Llabel = sprintf('L=%d',L);
    svals=[];
    psivals=[];
    for i=1:size(A,1)
        if(type1(j)==1)
            if mod(A(i,1),5)==0
                svals=[svals,A(i,1)];
                psivals=[psivals,psiave(i)];
            end
        end
        if(type2(j)==1)
            if mod(A(i,1)+2.5,5)==0
                svals=[svals,A(i,1)];
                psivals=[psivals,psiave(i)];
            end
        end
    end
    figure(2), hold on, plot(svals,psivals*L,Lmarkers{j},'MarkerFaceColor',fcolour{j},'MarkerSize',10,'DisplayName',Llabel);
    figure(2), hold on, plot(34,-2.5-2.5*j,Lmarkers{j},'MarkerFaceColor',fcolour{j},'MarkerSize',10,'DisplayName',Llabel);
    lLabel = sprintf('$L=%d$',L);
    text(37,-2.5-2.5*j,lLabel,'FontSize',20,'interpreter','latex');
end

figure(2), hold on, plot([32, 36],[-2.5,-2.5],'k-','LineWidth',3.2);
text(37,-2.5,'Theory','FontSize',20,'interpreter','latex');

hold on, plot([20,20],[0,-20],'k--','LineWidth',3.2);
hold on, plot([2,7],[-16,-16],'k--','LineWidth',3.2);
text(8.7,-15.8,'Phase','FontSize',16);
text(6,-17.5,'Transition','FontSize',16);

xlim([0,50]);
xlabel('$\lambda$','interpreter','latex');
ylabel('$\phi(\lambda)$','interpreter','latex');

set(gca, 'FontSize',24);
set(gca,'linewidth',2);
    
saveas(gcf,'Psi.png');